/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.qualified;

import iaik.utils.CollectionVector;
import iaik.utils.Util;
import iaik.x509.CertificateFactory;
import iaik.x509.X509Certificate;
import iaik.x509.qualified.QualifiedCertificate;
import iaik.x509.qualified.QualifiedCertificateException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collection;

public class QualifiedCertificateFactory
extends CertificateFactory {
    private static boolean a = false;

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        byte[] byArray = null;
        try {
            byArray = Util.readStream(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException("Error reading certificate: " + iOException.getMessage());
        }
        try {
            return new QualifiedCertificate(byArray);
        }
        catch (Exception exception) {
            if (a) {
                System.out.println("engineGenerateCertificate: no qualified cert");
            }
            return new X509Certificate(byArray);
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        Collection collection = super.engineGenerateCertificates(inputStream);
        Object[] objectArray = collection.toArray();
        CollectionVector collectionVector = new CollectionVector();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            X509Certificate x509Certificate = (X509Certificate)objectArray[i2];
            QualifiedCertificate qualifiedCertificate = null;
            try {
                qualifiedCertificate = QualifiedCertificate.isQualifedCertificate(x509Certificate);
                collectionVector.add(qualifiedCertificate);
                continue;
            }
            catch (QualifiedCertificateException qualifiedCertificateException) {
                collectionVector.add(x509Certificate);
            }
        }
        return collectionVector;
    }
}

