/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.security.random.SecRandom;
import iaik.utils.LineInputStream;
import iaik.utils.LineOutputStream;
import iaik.utils.Util;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SSLeayPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 8943736105225045343L;
    private int a;
    private String b;
    private int c;
    private byte[] d;
    private byte[] e;
    private boolean f;
    private PrivateKey g;

    public SSLeayPrivateKey(PrivateKey privateKey) throws InvalidKeyException, CodingException {
        this.g = privateKey;
        if (privateKey instanceof RSAPrivateKey) {
            this.a = 1;
        } else if (privateKey instanceof DSAPrivateKey) {
            this.a = 2;
        } else if (privateKey instanceof DHPrivateKey) {
            this.a = 3;
        } else {
            throw new InvalidKeyException("Unsupported key type: " + privateKey.getClass().getName());
        }
        this.a(privateKey);
    }

    public SSLeayPrivateKey(String string) throws IOException, InvalidKeyException {
        this(new FileInputStream(string));
    }

    public SSLeayPrivateKey(InputStream inputStream) throws IOException, InvalidKeyException {
        LineInputStream lineInputStream = new LineInputStream(inputStream);
        String string = lineInputStream.readLine();
        this.a = -1;
        if (string.startsWith("-----BEGIN ") && string.endsWith(" PRIVATE KEY-----")) {
            string = string.substring("-----BEGIN ".length(), string.length() - " PRIVATE KEY-----".length());
            this.a = SSLeayPrivateKey.a(string);
        }
        if (this.a < 0) {
            throw new IOException("No SSLeay private key!");
        }
        string = lineInputStream.readLine();
        if (string.equals("Proc-Type: 4,ENCRYPTED")) {
            this.f = true;
            string = lineInputStream.readLine();
            if (!string.startsWith("DEK-Info:")) {
                throw new IOException("Unknown SSLeay private key format!");
            }
            int n2 = string.indexOf(32);
            int n3 = string.indexOf(44);
            String string2 = string.substring(n2 + 1, n3);
            this.d = new BigInteger(string.substring(n3 + 1), 16).toByteArray();
            if (this.d.length > 8) {
                byte[] byArray = new byte[8];
                System.arraycopy(this.d, 1, byArray, 0, 8);
                this.d = byArray;
            }
            this.b(string2);
            while ((string = lineInputStream.readLine()).length() > 0) {
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!this.f) {
            byteArrayOutputStream.write(Util.toASCIIBytes(string));
        }
        while (!(string = lineInputStream.readLine()).startsWith("-----END ")) {
            byteArrayOutputStream.write(Util.toASCIIBytes(string));
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.e = Util.Base64Decode(byArray);
    }

    private static final String a(int n2) {
        switch (n2) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "DSA";
            }
            case 3: {
                return "DH";
            }
        }
        throw new IllegalArgumentException("Invalid algorithm: " + n2);
    }

    private static final int a(String string) {
        if (string.equals("RSA")) {
            return 1;
        }
        if (string.equals("DSA")) {
            return 2;
        }
        if (string.equals("DH")) {
            return 3;
        }
        return -1;
    }

    private void b(String string) throws InvalidKeyException {
        if (string == null || string.equals("DES-EDE3-CBC")) {
            this.b = "DESede/CBC/PKCS5Padding";
            this.c = 24;
        } else if (string.equals("DES-CBC")) {
            this.b = "DES/CBC/PKCS5Padding";
            this.c = 8;
        } else if (string.equals("IDEA-CBC")) {
            this.b = "IDEA/CBC/PKCS5Padding";
            this.c = 16;
        } else {
            throw new InvalidKeyException("Unknown SSLeay encryption algorithm!");
        }
    }

    private String a() {
        if (this.b.equals("DESede/CBC/PKCS5Padding")) {
            return "DES-EDE3-CBC";
        }
        if (this.b.equals("DES/CBC/PKCS5Padding")) {
            return "DES-CBC";
        }
        if (this.b.equals("IDEA/CBC/PKCS5Padding")) {
            return "IDEA-CBC";
        }
        throw new RuntimeException("Unknown algorithm: " + this.b);
    }

    private void a(PrivateKey privateKey) throws CodingException {
        ASN1 aSN1 = new ASN1(privateKey.getEncoded());
        this.e = (byte[])aSN1.getComponentAt(2).getValue();
    }

    public boolean isEncrypted() {
        return this.f;
    }

    public PrivateKey getPrivateKey() throws InvalidKeyException {
        if (this.f) {
            throw new InvalidKeyException("Private key not decrypted yet.");
        }
        if (this.g == null) {
            if (this.a == 1) {
                this.g = iaik.security.rsa.RSAPrivateKey.parse(this.e);
            } else if (this.a == 2) {
                try {
                    ASN1Object aSN1Object = DerCoder.decode(this.e);
                    BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(5).getValue();
                    BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
                    BigInteger bigInteger3 = (BigInteger)aSN1Object.getComponentAt(2).getValue();
                    BigInteger bigInteger4 = (BigInteger)aSN1Object.getComponentAt(3).getValue();
                    this.g = new iaik.security.dsa.DSAPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
                }
                catch (CodingException codingException) {
                    throw new InvalidKeyException("Error parsing DSA private key: " + codingException.toString());
                }
            } else {
                throw new InvalidKeyException("Unknown private key algorithm.");
            }
        }
        return this.g;
    }

    public void decrypt(String string) throws InvalidKeyException {
        if (!this.f) {
            return;
        }
        try {
            Cipher cipher = this.a(2, string);
            this.e = cipher.doFinal(this.e);
            this.f = false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException(generalSecurityException.toString());
        }
    }

    public void encrypt(String string, String string2, byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, GeneralSecurityException {
        if (this.f) {
            return;
        }
        this.d = byArray;
        this.b(string2);
        Cipher cipher = this.a(1, string);
        this.e = cipher.doFinal(this.e);
        this.f = true;
    }

    private Cipher a(int n2, String string) throws InvalidKeyException, NoSuchAlgorithmException, GeneralSecurityException {
        Object object;
        int n3;
        Object object2;
        byte[] byArray = Util.toASCIIBytes(string);
        Cipher cipher = Cipher.getInstance(this.b);
        if (this.d == null) {
            object2 = SecRandom.getDefault();
            n3 = cipher.getBlockSize();
            int n4 = n3 > 0 ? n3 : 1;
            this.d = new byte[n4];
            ((SecureRandom)object2).nextBytes(this.d);
        }
        object2 = this.d;
        n3 = 1;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray2 = new byte[this.c];
        int n5 = 0;
        while (n5 < this.c) {
            int n6;
            messageDigest.update(byArray);
            messageDigest.update((byte[])object2);
            object = messageDigest.digest();
            for (n6 = 1; n6 < n3; ++n6) {
                object = messageDigest.digest((byte[])object);
            }
            n6 = Math.min(((Object)object).length, this.c - n5);
            System.arraycopy(object, 0, byArray2, n5, n6);
            messageDigest.update(byArray2, 0, n5 += n6);
        }
        object = new SecretKeySpec(byArray2, Util.getRawCipherName(this.b));
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.d);
        cipher.init(n2, (Key)object, ivParameterSpec);
        return cipher;
    }

    public String getAlgorithm() {
        return this.b;
    }

    public byte[] getEncoded() {
        try {
            ASN1 aSN1 = new ASN1(this.g.getEncoded());
            return (byte[])aSN1.getComponentAt(2).getValue();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public String getFormat() {
        return "SSLeay";
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Object object;
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        String string = SSLeayPrivateKey.a(this.a);
        lineOutputStream.println("-----BEGIN " + string + " PRIVATE KEY-----");
        if (this.f) {
            lineOutputStream.println("Proc-Type: 4,ENCRYPTED");
            object = new StringBuffer();
            ((StringBuffer)object).append("DEK-Info: ");
            ((StringBuffer)object).append(this.a());
            ((StringBuffer)object).append(',');
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                ((StringBuffer)object).append(Util.toString(this.d[i2]));
            }
            lineOutputStream.println(((StringBuffer)object).toString());
            lineOutputStream.println();
        }
        object = Util.Base64Encode(this.e);
        lineOutputStream.println(Util.toASCIIString((byte[])object));
        lineOutputStream.println("-----END " + string + " PRIVATE KEY-----");
        lineOutputStream.flush();
    }
}

