/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.keystore;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.cipher.SecretKey;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;

public final class IAIKKeyStore
extends KeyStoreSpi {
    private int a = 32;
    private int b = 1000;
    private int c = 16;
    private SecureRandom d = SecRandom.getDefault();
    private Hashtable e = new Hashtable();

    private byte[] a() {
        byte[] byArray = new byte[this.c];
        this.d.nextBytes(byArray);
        return byArray;
    }

    private ASN1Object a(byte[] byArray) {
        OCTET_STRING oCTET_STRING = new OCTET_STRING(byArray);
        ObjectID objectID = new ObjectID("1.2.840.113549.1.5.9", null, null, false);
        AlgorithmID algorithmID = new AlgorithmID(objectID, oCTET_STRING);
        return algorithmID.toASN1Object();
    }

    private INTEGER b() {
        Date date = new Date();
        BigInteger bigInteger = BigInteger.valueOf(date.getTime());
        return new INTEGER(bigInteger);
    }

    private Date a(INTEGER iNTEGER) {
        BigInteger bigInteger = (BigInteger)iNTEGER.getValue();
        return new Date(bigInteger.longValue());
    }

    private byte[] a(int n2, Key key, byte[] byArray) throws KeyStoreException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray, 24, 8);
            SecretKey secretKey = new SecretKey(byArray, 0, 24, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "IAIK");
            int n3 = n2 == 0 ? 1 : 2;
            cipher.init(n3, (Key)secretKey, ivParameterSpec, null);
            byte[] byArray2 = key.getEncoded();
            byte[] byArray3 = cipher.doFinal(byArray2);
            return byArray3;
        }
        catch (Exception exception) {
            throw new KeyStoreException("Crypt failed: " + exception.toString());
        }
    }

    private SecretKey a(char[] cArray, byte[] byArray) {
        SecretKey secretKey;
        block7: {
            PBEKeyAndParameterSpec pBEKeyAndParameterSpec = null;
            byte[] byArray2 = IAIKKeyStore.a(cArray);
            try {
                SecretKey secretKey2;
                KeyGenerator keyGenerator = null;
                keyGenerator = KeyGenerator.getInstance("PBKDF2", "IAIK");
                pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(byArray2, byArray, this.b, this.a);
                keyGenerator.init(pBEKeyAndParameterSpec, null);
                secretKey = secretKey2 = (SecretKey)keyGenerator.generateKey();
                if (pBEKeyAndParameterSpec == null) break block7;
                byArray2 = pBEKeyAndParameterSpec.getPassword();
            }
            catch (Exception exception) {
                try {
                    throw new InternalErrorException("Could not generate key: " + exception.toString());
                }
                catch (Throwable throwable) {
                    if (pBEKeyAndParameterSpec != null) {
                        byArray2 = pBEKeyAndParameterSpec.getPassword();
                        for (int i2 = 0; i2 < byArray2.length; ++i2) {
                            byArray2[i2] = 0;
                        }
                    }
                    throw throwable;
                }
            }
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                byArray2[i3] = 0;
            }
        }
        return secretKey;
    }

    private int a(SEQUENCE sEQUENCE) {
        if (sEQUENCE == null) {
            return 10;
        }
        int n2 = sEQUENCE.countComponents();
        if (n2 > 3 || n2 < 1) {
            return 10;
        }
        int n3 = -1;
        try {
            sEQUENCE.getComponentAt(0);
            if (n2 == 1) {
                return 11;
            }
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
            n3 = cON_SPEC.getAsnType().getTag();
        }
        catch (Exception exception) {
            return 10;
        }
        switch (n3) {
            case 0: {
                return 12;
            }
            case 1: {
                return 13;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
        }
        return 10;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] byArray;
        byte[] byArray2;
        OCTET_STRING oCTET_STRING;
        Object object;
        if (string == null) {
            throw new UnrecoverableKeyException("Alias has to be specified.");
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.e.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = this.a(sEQUENCE);
        if (n2 == 10) {
            throw new UnrecoverableKeyException("Invalid keystore record.");
        }
        if (n2 == 15) {
            throw new UnrecoverableKeyException("This alias specifies a certificate entry.");
        }
        if (n2 == 11) {
            throw new UnrecoverableKeyException("This alias specifies a date entry.");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        int n3 = cON_SPEC.getAsnType().getTag();
        if (n3 == 2) {
            ASN1Object aSN1Object = cON_SPEC.getComponentAt(0);
            try {
                if (cArray == null || cArray.length == 0) {
                    return new EncryptedPrivateKeyInfo(aSN1Object);
                }
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(aSN1Object);
                return encryptedPrivateKeyInfo.decrypt(cArray);
            }
            catch (Exception exception) {
                throw new UnrecoverableKeyException("Wrong password: " + exception.toString());
            }
        }
        if (cArray == null || cArray.length == 0) {
            throw new UnrecoverableKeyException("Password has to be specified!");
        }
        SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
        SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE2.getComponentAt(0);
        byte[] byArray3 = null;
        try {
            object = (ObjectID)sEQUENCE3.getComponentAt(0);
            if (!((ObjectID)object).getID().equals("1.2.840.113549.1.5.9")) {
                throw new UnrecoverableKeyException("Unknown OID: " + object);
            }
            oCTET_STRING = (OCTET_STRING)sEQUENCE3.getComponentAt(1);
            byArray3 = oCTET_STRING.getWholeValue();
            if (byArray3.length != this.c) {
                throw new UnrecoverableKeyException("Invalid salt");
            }
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("Cannot parse key: " + exception.toString());
        }
        object = this.a(cArray, byArray3);
        oCTET_STRING = (OCTET_STRING)sEQUENCE2.getComponentAt(1);
        try {
            byArray2 = oCTET_STRING.getWholeValue();
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException("Cannot parse key: " + iOException.toString());
        }
        SecretKey secretKey = new SecretKey(byArray2, "RAW");
        try {
            byArray = this.a(1, secretKey, ((SecretKey)object).getEncoded());
        }
        catch (KeyStoreException keyStoreException) {
            throw new UnrecoverableKeyException(keyStoreException.getMessage());
        }
        if (n3 == 0) {
            return new SecretKey(byArray, "RAW");
        }
        try {
            return PrivateKeyInfo.getPrivateKey(byArray);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.e.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = sEQUENCE.countComponents();
        if (n2 != 3) {
            return null;
        }
        int n3 = this.a(sEQUENCE);
        if (n3 == 13 || n3 == 14) {
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(2);
            SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
            int n4 = sEQUENCE2.countComponents();
            Certificate[] certificateArray = new X509Certificate[n4];
            try {
                for (int i2 = 0; i2 < n4; ++i2) {
                    ASN1Object aSN1Object = sEQUENCE2.getComponentAt(i2);
                    X509Certificate x509Certificate = new X509Certificate();
                    x509Certificate.decode(aSN1Object);
                    certificateArray[i2] = x509Certificate;
                }
            }
            catch (CodingException codingException) {
                return null;
            }
            return certificateArray;
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        CON_SPEC cON_SPEC;
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.e.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = sEQUENCE.countComponents();
        int n3 = this.a(sEQUENCE);
        if (n3 == 15) {
            cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        } else if (n2 == 3) {
            cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(2);
        } else {
            return null;
        }
        SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
        ASN1Object aSN1Object = sEQUENCE2.getComponentAt(0);
        X509Certificate x509Certificate = new X509Certificate();
        try {
            x509Certificate.decode(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException.getMessage());
        }
        return x509Certificate;
    }

    public Date engineGetCreationDate(String string) {
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.e.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = this.a(sEQUENCE);
        if (n2 == 10) {
            return null;
        }
        INTEGER iNTEGER = (INTEGER)sEQUENCE.getComponentAt(0);
        return this.a(iNTEGER);
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Object object;
        Object object2;
        int n2;
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified.");
        }
        if (key == null) {
            throw new KeyStoreException("Key has to be specified.");
        }
        if (key instanceof EncryptedPrivateKeyInfo) {
            n2 = 14;
        } else {
            if (cArray == null) {
                throw new KeyStoreException("Password has to be specified.");
            }
            if (key instanceof javax.crypto.SecretKey) {
                n2 = 12;
            } else {
                try {
                    PrivateKeyInfo.getPrivateKey(key.getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new KeyStoreException("Unknown private key type.");
                }
                n2 = 13;
            }
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b());
        if (n2 == 14) {
            sEQUENCE.addComponent(new CON_SPEC(2, ((EncryptedPrivateKeyInfo)key).toASN1Object(), false));
        } else {
            object2 = this.a();
            SecretKey secretKey = this.a(cArray, (byte[])object2);
            object = this.a(0, key, secretKey.getEncoded());
            ASN1Object aSN1Object = this.a((byte[])object2);
            OCTET_STRING oCTET_STRING = new OCTET_STRING((byte[])object);
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(aSN1Object);
            sEQUENCE2.addComponent(oCTET_STRING);
            if (n2 == 12) {
                sEQUENCE.addComponent(new CON_SPEC(0, sEQUENCE2, false));
            }
            if (n2 == 13) {
                sEQUENCE.addComponent(new CON_SPEC(1, sEQUENCE2, false));
            }
        }
        if (certificateArray != null && certificateArray[0] != null) {
            object2 = new SEQUENCE();
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                try {
                    object = DerCoder.decode(certificateArray[i2].getEncoded());
                    ((ConstructedType)object2).addComponent((ASN1Object)object);
                    continue;
                }
                catch (Exception exception) {
                    throw new InternalErrorException("Could not encode certificate: " + exception.toString());
                }
            }
            sEQUENCE.addComponent(new CON_SPEC(3, (ASN1Object)object2, false));
        }
        this.e.put(string, sEQUENCE);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified. ");
        }
        if (byArray == null || byArray.length == 0) {
            throw new KeyStoreException("Key has to be specified. ");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b());
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            sEQUENCE.addComponent(new CON_SPEC(2, encryptedPrivateKeyInfo.toASN1Object(), false));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyStoreException("Key is not a PKCS#8-EncryptedPrivateKeyInfo. ");
        }
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        if (certificateArray != null && certificateArray[0] != null) {
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                try {
                    ASN1Object aSN1Object = DerCoder.decode(certificateArray[i2].getEncoded());
                    sEQUENCE2.addComponent(aSN1Object);
                    continue;
                }
                catch (Exception exception) {
                    throw new InternalErrorException("Could not decode certificate: " + exception.toString());
                }
            }
            sEQUENCE.addComponent(new CON_SPEC(3, sEQUENCE2, false));
        }
        this.e.put(string, sEQUENCE);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        ASN1Object aSN1Object;
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified.");
        }
        if (certificate == null) {
            throw new KeyStoreException("Certificate has to be specified.");
        }
        if (this.engineIsKeyEntry(string)) {
            throw new KeyStoreException("This alias is already used by a key.");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b());
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        try {
            aSN1Object = DerCoder.decode(certificate.getEncoded());
        }
        catch (Exception exception) {
            throw new InternalErrorException("Could not encoding certificate: " + exception.toString());
        }
        sEQUENCE2.addComponent(aSN1Object);
        sEQUENCE.addComponent(new CON_SPEC(3, sEQUENCE2, false));
        this.e.put(string, sEQUENCE);
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (string != null) {
            this.e.remove(string);
        }
    }

    public Enumeration engineAliases() {
        return this.e.keys();
    }

    public boolean engineContainsAlias(String string) {
        if (string == null) {
            return false;
        }
        return this.e.containsKey(string);
    }

    public int engineSize() {
        return this.e.size();
    }

    public boolean engineIsKeyEntry(String string) {
        if (string == null) {
            return false;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.e.get(string);
        int n2 = this.a(sEQUENCE);
        switch (n2) {
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean engineIsCertificateEntry(String string) {
        if (string == null) {
            return false;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.e.get(string);
        int n2 = this.a(sEQUENCE);
        return n2 == 15;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        try {
            byte[] byArray = certificate.getEncoded();
            Enumeration enumeration = this.engineAliases();
            while (enumeration.hasMoreElements()) {
                byte[] byArray2;
                String string = (String)enumeration.nextElement();
                Certificate certificate2 = this.engineGetCertificate(string);
                if (certificate2 == null || !CryptoUtils.equalsBlock(byArray, byArray2 = certificate2.getEncoded())) continue;
                return string;
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        ConstructedType constructedType;
        Object object;
        Mac mac;
        if (cArray == null || cArray.length == 0) {
            throw new IOException("Password must be specified.");
        }
        byte[] byArray = this.a();
        SecretKey secretKey = this.a(cArray, byArray);
        try {
            mac = Mac.getInstance("HMAC/SHA", "IAIK");
            mac.init(secretKey);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Could not initialize HMAC. ");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        Object object2 = this.e.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            constructedType = new OCTET_STRING(IAIKKeyStore.a((String)object));
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(constructedType);
            sEQUENCE2.addComponent((ASN1Object)this.e.get(object));
            sEQUENCE.addComponent(sEQUENCE2);
        }
        mac.update(DerCoder.encode(sEQUENCE));
        object2 = this.a(byArray);
        object = mac.doFinal(DerCoder.encode((ASN1Object)object2));
        constructedType = new SEQUENCE();
        constructedType.addComponent(sEQUENCE);
        constructedType.addComponent((ASN1Object)object2);
        constructedType.addComponent(new OCTET_STRING((byte[])object));
        outputStream.write(DerCoder.encode(constructedType));
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.e.clear();
        if (inputStream == null) {
            return;
        }
        try {
            Mac mac;
            ASN1 aSN1 = new ASN1(inputStream);
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1.getComponentAt(0);
            if (cArray == null) {
                throw new IOException("Password must be specified.");
            }
            SEQUENCE sEQUENCE2 = (SEQUENCE)aSN1.getComponentAt(1);
            OCTET_STRING oCTET_STRING = (OCTET_STRING)sEQUENCE2.getComponentAt(1);
            OCTET_STRING oCTET_STRING2 = (OCTET_STRING)aSN1.getComponentAt(2);
            byte[] byArray = (byte[])oCTET_STRING.getValue();
            SecretKey secretKey = this.a(cArray, byArray);
            try {
                mac = Mac.getInstance("HMAC/SHA", "IAIK");
                mac.init(secretKey);
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Could not initialize HMAC: " + exception.toString());
            }
            mac.update(aSN1.getFirstObject());
            byte[] byArray2 = mac.doFinal(DerCoder.encode(sEQUENCE2));
            if (!CryptoUtils.secureEqualsBlock((byte[])oCTET_STRING2.getValue(), byArray2)) {
                throw new IOException(this, "Integrity verification failed! HMAC not valid. "){
                    private static final long serialVersionUID = 1811236715520167575L;
                    private final IAIKKeyStore a;
                    {
                        this.a = iAIKKeyStore;
                    }

                    public Throwable getCause() {
                        return new UnrecoverableKeyException("Integrity verification failed! HMAC not valid. Wrong password!");
                    }
                };
            }
            for (int i2 = 0; i2 < sEQUENCE.countComponents(); ++i2) {
                SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE.getComponentAt(i2);
                OCTET_STRING oCTET_STRING3 = (OCTET_STRING)sEQUENCE3.getComponentAt(0);
                SEQUENCE sEQUENCE4 = (SEQUENCE)sEQUENCE3.getComponentAt(1);
                this.e.put(IAIKKeyStore.b((byte[])oCTET_STRING3.getValue()), sEQUENCE4);
            }
        }
        catch (CodingException codingException) {
            throw new IOException("CodingException: " + codingException.getMessage());
        }
    }

    private static byte[] a(char[] cArray) {
        try {
            return UTF8String.getUTF8EncodingFromCharArray(cArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    private static byte[] a(String string) {
        try {
            return UTF8String.getUTF8EncodingFromString(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    private static String b(byte[] byArray) {
        try {
            return UTF8String.getStringFromUTF8Encoding(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    static {
        Util.toString(null, -1, 1);
    }
}

