/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHPublicKey;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DHKeyAgreement
extends KeyAgreementSpi {
    private DHPrivateKey a;
    private BigInteger b;
    private BigInteger c;
    private byte[] d;

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Only DH private keys are allowed.");
        }
        this.a = (DHPrivateKey)key;
        this.b = this.a.getParams().getP();
        this.c = this.a.getParams().getG();
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(key, null, secureRandom);
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (key instanceof javax.crypto.interfaces.DHPublicKey) {
            javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)key;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            if (!this.b.equals(dHParameterSpec.getP()) || !this.c.equals(dHParameterSpec.getG())) {
                throw new InvalidKeyException("DH parameters are not equal.");
            }
            BigInteger bigInteger = dHPublicKey.getY().modPow(this.a.getX(), this.b);
            if (bl) {
                this.d = bigInteger.toByteArray();
                if (this.d[0] == 0) {
                    byte[] byArray = new byte[this.d.length - 1];
                    System.arraycopy(this.d, 1, byArray, 0, this.d.length - 1);
                    this.d = byArray;
                }
                return null;
            }
            return new DHPublicKey(bigInteger, this.a.getParams());
        }
        throw new InvalidKeyException("DH public key needed.");
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKey secretKey = null;
        SecretKeySpec secretKeySpec = null;
        try {
            secretKeySpec = new SecretKeySpec(this.d, string);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            secretKey = secretKeyFactory.generateSecret(secretKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Invalid key: " + invalidKeySpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            secretKey = secretKeySpec;
        }
        return secretKey;
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        if (byArray.length - n2 < this.d.length) {
            throw new ShortBufferException("Output buffer is to small for holding the secret.");
        }
        System.arraycopy(this.d, 0, byArray, n2, this.d.length);
        return this.d.length;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.d;
    }

    static {
        Util.toString(null, -1, 1);
    }
}

