/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataStream
implements ContentStream {
    InputStream b;
    int c = 2048;

    protected DataStream() {
    }

    public DataStream(InputStream inputStream, int n2) {
        this();
        this.b = inputStream;
        this.c = n2;
    }

    public DataStream(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        if (inputStream == null) {
            throw new IOException("Cannot decode a null object!");
        }
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        if (derInputStream.nextTag() != 4) {
            throw new IOException("Next tag no OCTET STRING!");
        }
        this.b = derInputStream.readOctetString();
    }

    public void setBlockSize(int n2) {
        this.c = n2;
    }

    public int getBlockSize() {
        return this.c;
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_data;
    }

    public InputStream getInputStream() {
        return this.b;
    }

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.c > 0) {
            return new OCTET_STRING(this.b, this.c);
        }
        return new OCTET_STRING(this.b);
    }

    public void writeTo(OutputStream outputStream) throws PKCSException, IOException {
        DerCoder.encodeTo(this.toASN1Object(), outputStream);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS#7 Data: ");
        if (this.b != null) {
            try {
                stringBuffer.append(this.b.available() + " bytes available from input stream ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                stringBuffer.append(this.b);
            }
        } else {
            stringBuffer.append("no content!");
        }
        return stringBuffer.toString();
    }
}

