/*
 * Decompiled with CFR 0.152.
 */
package iaik.iso.iso9796;

import iaik.utils.Util;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class ISO9796P2ParameterSpec
implements AlgorithmParameterSpec {
    SecureRandom a;
    private MessageDigest b;
    private int c = -1;
    private int d;
    private boolean e = false;
    private boolean f = true;

    public void setHashEngine(MessageDigest messageDigest, int n2) {
        if (messageDigest == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Hash length must not be negative!");
        }
        this.b = messageDigest;
        this.d = n2;
    }

    public MessageDigest getHashEngine() {
        return this.b;
    }

    public int getHashLen() {
        return this.d;
    }

    public void setHashID(int n2) {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("Invalid hash id (" + n2 + "). Has to be in the range from 0 to 255");
        }
        this.c = n2;
    }

    public int getHashID() {
        return this.c;
    }

    public void setUseExplicitTrailer(boolean bl) {
        this.e = bl;
    }

    public boolean getUseExplicitTrailer() {
        return this.e;
    }

    public void setUseAlternativeSignatureFunction(boolean bl) {
        this.f = bl;
    }

    public boolean getUseAlternativeSignatureFunction() {
        return this.f;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.a = secureRandom;
    }

    public SecureRandom getSecureRandom() {
        return this.a;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash engine: " + (this.b == null ? "not set" : this.b.getAlgorithm()) + "\n");
        stringBuffer.append("Hash output length: " + this.d + "\n");
        if (this.c > -1) {
            stringBuffer.append("Hash id: " + Util.toString(this.c) + "\n");
        }
        if (this.e) {
            stringBuffer.append("Explicit trailer\n");
        } else {
            stringBuffer.append("Implicit trailer\n");
        }
        if (this.a != null) {
            stringBuffer.append("Random source: set\n");
        }
        return stringBuffer.toString();
    }
}

