/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.xml.crypto.dom.DOMCryptoContext;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.enc.spec.OAEPParamsImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.filter.impl.enc.WrapInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.enc.spec.RSAOAEPParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RSAOAEPAlgorithmParameter
extends AlgorithmParametersSpi {
    protected DigestMethodImpl digestMethod_;
    protected OAEPParamsImpl oaepParams_;
    static Class a;
    static Class b;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof RSAOAEPParameterSpec) {
            this.digestMethod_ = (DigestMethodImpl)((RSAOAEPParameterSpec)algorithmParameterSpec).getDigestMethod();
            byte[] byArray = ((RSAOAEPParameterSpec)algorithmParameterSpec).getOAEPParams();
            if (byArray != null) {
                this.oaepParams_ = new OAEPParamsImpl(byArray);
            }
        } else {
            throw new InvalidParameterSpecException((a == null ? (a = RSAOAEPAlgorithmParameter.a("javax.xml.crypto.enc.spec.RSAOAEPParameterSpec")) : a).getName() + " expected.");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        Document document;
        WrapInputStream wrapInputStream = new WrapInputStream(new ByteArrayInputStream(byArray), null);
        try {
            document = DOMUtils.parse(wrapInputStream, null, null, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Failed to parse RSAOAEP parameter. " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException("Failed to parse RSAOAEP parameter. " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new IOException("Failed to parse RSAOAEP parameter. " + iOException.getMessage());
        }
        try {
            NodeList nodeList;
            DOMCryptoContext dOMCryptoContext = new DOMCryptoContext();
            NodeList nodeList2 = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
            if (nodeList2.getLength() == 1) {
                this.digestMethod_ = (DigestMethodImpl)DOMStructure.getInstance(nodeList2.item(0), dOMCryptoContext);
            }
            if ((nodeList = document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OAEPparams")).getLength() == 1) {
                this.oaepParams_ = (OAEPParamsImpl)DOMStructure.getInstance(nodeList.item(0), dOMCryptoContext);
            }
        }
        catch (MarshalException marshalException) {
            throw new IOException("Failed to unmarshal RSAOAEP parameters. " + marshalException.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (!"XML".equalsIgnoreCase(string)) {
            throw new IOException("Encoding format '" + string + "' is not supported.");
        }
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(b == null ? (b = RSAOAEPAlgorithmParameter.a("javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec")) : b)) {
            DigestMethodImpl digestMethodImpl = null;
            try {
                digestMethodImpl = this.digestMethod_ != null ? this.digestMethod_ : new DigestMethodImpl("http://www.w3.org/2000/09/xmldsig#sha1", null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidParameterSpecException(noSuchAlgorithmException.getMessage());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterSpecException(invalidAlgorithmParameterException.getMessage());
            }
            if (this.oaepParams_ == null) {
                return new RSAOAEPParameterSpec(digestMethodImpl);
            }
            return new RSAOAEPParameterSpec(digestMethodImpl, this.oaepParams_.getParams());
        }
        throw new InvalidParameterSpecException();
    }

    protected byte[] engineGetEncoded() throws IOException {
        if (this.digestMethod_ == null && this.oaepParams_ == null) {
            return null;
        }
        try {
            Node node;
            Document document = DOMUtils.newDocument(Boolean.TRUE, null, null);
            DOMCryptoContext dOMCryptoContext = new DOMCryptoContext();
            Element element = document.createElementNS("", "Dummy");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (this.oaepParams_ != null) {
                node = this.oaepParams_.marshal(dOMCryptoContext, element, null);
                transformer.transform(new DOMSource(node), new StreamResult(byteArrayOutputStream));
            }
            if (this.digestMethod_ != null) {
                node = this.digestMethod_.marshal(dOMCryptoContext, element, null);
                transformer.transform(new DOMSource(node), new StreamResult(byteArrayOutputStream));
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new IOException("Failed to marshal RSAOAEP parameters." + exception.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if ("XML".equalsIgnoreCase(string)) {
            return this.engineGetEncoded();
        }
        throw new IOException("Encoding format '" + string + "' is not supported.");
    }

    protected String engineToString() {
        return super.toString();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

