/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keys;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.Constants;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11TokenUnavailableException;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class IAIKPKCS11Key
implements Key {
    public static final String RSA = "RSA";
    public static final String DSA = "DSA";
    public static final String DH = "DH";
    public static final String ECDSA = "ECDSA";
    public static final String KEA = "KEA";
    public static final String GENERIC_SECRET = "GENERIC_SECRET";
    public static final String RC2 = "RC2";
    public static final String RC4 = "RC4";
    public static final String DES = "DES";
    public static final String DES2 = "DES2";
    public static final String DESede = "DESede";
    public static final String CAST = "CAST";
    public static final String CAST3 = "CAST3";
    public static final String CAST5 = "CAST5";
    public static final String CAST128 = "CAST128";
    public static final String RC5 = "RC5";
    public static final String IDEA = "IDEA";
    public static final String SKIPJACK = "SKIPJACK";
    public static final String BATON = "BATON";
    public static final String JUNIPER = "JUNIPER";
    public static final String CDMF = "CDMF";
    public static final String AES = "AES";
    public static final String BLOWFISH = "BLOWFISH";
    public static final String TWOFISH = "TWOFISH";
    public static final String VENDOR_DEFINED = "VENDOR_DEFINED";
    protected static Map a;
    protected static final Map b;
    private static boolean j;
    private static boolean k;
    protected TokenManager c;
    protected iaik.pkcs.pkcs11.objects.Key d;
    protected String e;
    protected Session f;
    protected boolean g;
    protected boolean h;
    static Class i;

    protected static boolean b() {
        if (!k) {
            try {
                String string = System.getProperty("java.version");
                if (string != null && string.compareTo("1.5") < 0) {
                    j = false;
                } else {
                    Class.forName("iaik.security.ec.common.ECParameterSpec");
                    j = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                j = false;
            }
            catch (SecurityException securityException) {
                j = false;
            }
            k = true;
            return j;
        }
        return j;
    }

    public static IAIKPKCS11Key create(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.Key key) {
        IAIKPKCS11Key iAIKPKCS11Key;
        if (key instanceof PrivateKey) {
            iAIKPKCS11Key = IAIKPKCS11PrivateKey.create(tokenManager, (PrivateKey)key);
        } else if (key instanceof PublicKey) {
            iAIKPKCS11Key = IAIKPKCS11PublicKey.create(tokenManager, (PublicKey)key);
        } else if (key instanceof SecretKey) {
            iAIKPKCS11Key = IAIKPKCS11SecretKey.create(tokenManager, (SecretKey)key);
        } else {
            throw new IAIKPkcs11Exception("Unrecognized PKCS#11 object type: " + key.getClass().getName());
        }
        return iAIKPKCS11Key;
    }

    public static String getAlgorithmName(int n) {
        return (String)a.get(new Long(n));
    }

    public static Long getAlgorithmCode(String string) {
        return (Long)b.get(string);
    }

    protected IAIKPKCS11Key(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.Key key) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null");
        }
        this.c = tokenManager;
        this.d = key;
    }

    public void destroy() {
        if (!this.h) {
            Session session = null;
            try {
                Token token = this.c.getToken();
                if (token != null) {
                    boolean bl = this.d.getToken().getBooleanValue();
                    session = bl ? this.c.getSession(true) : this.c.getSession(false);
                    boolean bl2 = this.d.getPrivate().getBooleanValue();
                    if (bl2) {
                        this.c.makeAuthorizedSession(session, null);
                    }
                } else {
                    throw new IAIKPkcs11TokenUnavailableException("The token is unavailable.");
                }
                session.destroyObject((iaik.pkcs.pkcs11.objects.Object)this.d);
                this.h = true;
                this.setSession(null);
                if (session != null) {
                    this.c.disposeSession(session);
                }
            }
            catch (Exception exception) {
                try {
                    throw new IAIKPkcs11Exception(exception.toString());
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        this.c.disposeSession(session);
                    }
                    throw throwable;
                }
            }
        }
    }

    public boolean isDestroyed() {
        return this.h;
    }

    public String getAlgorithm() {
        return IAIKPKCS11Key.getAlgorithmName(this.d.getKeyType().getLongValue().intValue());
    }

    public String getAlias() {
        if (this.e == null) {
            char[] cArray = this.d.getLabel().getCharArrayValue();
            this.e = cArray != null ? new String(cArray) : null;
        }
        return this.e;
    }

    public TokenManager getTokenManager() {
        return this.c;
    }

    public iaik.pkcs.pkcs11.objects.Key getKeyObject() {
        return this.d;
    }

    public byte[] getKeyID() {
        return this.d.getId().getByteArrayValue();
    }

    public byte[] getEncoded() {
        return null;
    }

    public String getFormat() {
        return null;
    }

    public Session getSession() {
        return this.f;
    }

    public void setSession(Session session) {
        if (session != null) {
            this.f = session;
            this.c.acquireSessionCloseLock(session);
        } else if (this.f != null) {
            this.c.releaseSessionCloseLock(this.f);
            this.f = null;
        }
    }

    public void setAutoDestroy(boolean bl) {
        this.g = bl;
    }

    public boolean isAutoDestroy() {
        return this.g;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS#11 key object: ");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append(this.d.toString());
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append("on token: ");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        try {
            stringBuffer.append(this.c.getToken().getTokenInfo().toString());
        }
        catch (TokenException tokenException) {
            stringBuffer.append("Error getting token info: " + tokenException.toString());
        }
        return stringBuffer.toString();
    }

    public void finalize() {
        if (this.g) {
            try {
                this.destroy();
            }
            catch (Exception exception) {}
        } else {
            this.setSession(null);
        }
        super.finalize();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        Iterator<Object> iterator;
        a = new HashMap(32);
        a.put(new Long(0L), RSA);
        a.put(new Long(1L), DSA);
        a.put(new Long(2L), DH);
        a.put(new Long(3L), ECDSA);
        a.put(new Long(5L), KEA);
        a.put(new Long(16L), GENERIC_SECRET);
        a.put(new Long(17L), RC2);
        a.put(new Long(18L), RC4);
        a.put(new Long(19L), DES);
        a.put(new Long(20L), DES2);
        a.put(new Long(21L), DESede);
        a.put(new Long(22L), CAST);
        a.put(new Long(23L), CAST3);
        a.put(new Long(24L), CAST5);
        a.put(new Long(24L), CAST128);
        a.put(new Long(25L), RC5);
        a.put(new Long(26L), IDEA);
        a.put(new Long(27L), SKIPJACK);
        a.put(new Long(28L), BATON);
        a.put(new Long(29L), JUNIPER);
        a.put(new Long(30L), CDMF);
        a.put(new Long(31L), AES);
        a.put(new Long(32L), BLOWFISH);
        a.put(new Long(33L), TWOFISH);
        a.put(new Long(0x80000000L), VENDOR_DEFINED);
        Properties properties = new Properties();
        try {
            properties.load((i == null ? (i = IAIKPKCS11Key.a("iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key")) : i).getClassLoader().getResourceAsStream("iaik/pkcs/pkcs11/provider/keys/IAIKPKCS11Key.properties"));
            iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string = properties.getProperty((String)object);
                try {
                    if (((String)object).startsWith("0x")) {
                        object = ((String)object).substring(2);
                    }
                    Long l2 = Long.valueOf((String)object, 16);
                    a.put(l2, string);
                }
                catch (Exception exception) {
                    IAIKPkcs11.errorStream_.println("Error in properties file iaik/pkcs/pkcs11/provider/keys/IAIKPKCS11Key.properties in entry " + (String)object + ". Trying to continue.");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        b = new HashMap(32);
        iterator = a.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            b.put(object.getValue(), object.getKey());
        }
    }
}

